-- Uh oh, here we go.
local curStyle = GAMESTATE:GetCurrentStyle()
local columnCount = curStyle:ColumnsPerPlayer()

local keysThatWork = {1,2,3,4,5,6,7,8,9,0}

local function InputHandler( event )
	-- Style type check 'cause the Alt key doesn't affect anything in "single" play modes
	if string.find(event.DeviceInput.button, "alt") and curStyle:GetStyleType() ~= "StyleType_OnePlayerOneSide" then
		if event.type == "InputEventType_FirstPress" then
			--SM(":V")
			MESSAGEMAN:Broadcast("Alt", {Held = true})
		elseif event.type == "InputEventType_Release" then
			--SM(":|")
			MESSAGEMAN:Broadcast("Alt", {Held = false})
		end
	end
end

local t = Def.ActorFrame{
	ShowCommand=cmd(visible,true),
	HideCommand=cmd(visible,false),
	BeginCommand = function(self)
		-- todo: get rid of all these OnCommand message broadcasts for iffy things
		MESSAGEMAN:Broadcast("Alt", {Held = false})
		SCREENMAN:GetTopScreen():AddInputCallback( InputHandler )
	end,
	OnCommand=cmd(playcommand,"Show"),
	EditCommand=cmd(playcommand,"Show"),
	PlayingCommand=cmd(playcommand,"Hide"),
	RecordCommand=cmd(playcommand,"Hide"),
	RecordPausedCommand=cmd(playcommand,"Hide"),
	
	-- These are just little quads to back all the info text.
	Def.Quad {
		InitCommand=cmd(y,_screen.cy;horizalign,left;zoomto,_screen.w/6,_screen.h;diffuse,Color.Alpha(LocalBlueColor(1),0.5))
	},
	Def.Quad {
		InitCommand=cmd(x,_screen.w;y,_screen.cy;horizalign,right;zoomto,_screen.w/6,_screen.h;diffuse,Color.Alpha(LocalBlueColor(1),0.5))
	}
}

for i=1, columnCount do
	local adjI = (i - (columnCount/2)) - 0.5
	-- "Keys" return!
	t[#t+1] = Def.ActorFrame {
		Name = i,
		OnCommand=function(self)
			-- Get the column info for truly precise spacing
			self:xy(_screen.cx + ( (curStyle:GetColumnInfo(GAMESTATE:GetMasterPlayerNumber(), i).XOffset) / 2),32)
		end,
		AltMessageCommand=function(self, params)
			local altI = (params and params.Held) and i - (columnCount/2) or i
			if keysThatWork[altI] then
				--self:GetChild("KeyBorder"):diffusealpha(1)
				self:GetChild("KeyInside"):diffusealpha(1)
				self:GetChild("KeyText"):settext(tostring(keysThatWork[altI]))
			else
				--self:GetChild("KeyBorder"):diffusealpha(0.5)
				self:GetChild("KeyInside"):diffusealpha(0.5)
				self:GetChild("KeyText"):settext("")
			end
		end,
		
		-- Border...
		-- LoadActor(THEME:GetPathG("_frame","3x3"), "normal", 18, 18) .. {
			-- Name = "KeyBorder",
			-- InitCommand=cmd(diffuse,MESColor[49])
		-- },
		-- filling...
		Def.Quad {
			Name = "KeyInside",
			InitCommand=cmd(zoomto,18,18;diffuse,color("#111111"))
		},
		-- and uh, number
		LoadFont("Common Normal") .. {
			Name = "KeyText",
			InitCommand=cmd(zoom,0.75;diffuse,i % 2 == 0 and NeonColor.Gold or LocalGoldColor(1);strokecolor,Color.Outline)
		},
	}
end

return t